#define LIGHTING
#include "InventorBasicEffectDx10.fxh"

struct VSPosNormColTex
{
	float3 Pos			: Position;
	float3 Norm			: Normal;
	float4 Col			: Color;
	float2 Tex			: TEXCOORD0;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosNormColTex( VSPosNormColTex Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	float3 Viewer = -normalize(ViewPos);                   //viewer
	float3 ViewNormal = mul(Input.Norm, (float3x3)g_matWorldViewIT);//normal in view space
	ViewNormal = normalize(ViewNormal);

#ifdef DIFFUSE_TEXTURE
	Out.Tex = float4(Input.Tex, 0, 1.0f);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

#ifdef ENVIRONMENT_TEXTURE
	float3 VwNorm = normalize(mul(Viewer, (float3x3)transpose(g_matView)));
	float3 Nw = normalize(mul(ViewNormal, (float3x3)transpose(g_matView)));	
	Out.EnvTex = float4(2.f * dot(VwNorm,Nw) * Nw - VwNorm, 1.0f);
	Out.EnvTex = mul(Out.EnvTex, g_matEnvTex);
#endif
	
	float4 Emissive = float4(0,0,0,0);
	//Input color is compressed as a Dword in vertex buffer. 
	//But Dx9 is incompatiable to translate this Dword into float4 with Dx10. Dx9 treats Dword as ARGB. Dx10 treats Dword as ABGR.
	//And Dword is padding with order ARGB in application layer. So a translation is needed in Dx10.
	float4 Ambient = Input.Col.zyxw;
	//Input color is compressed as a Dword in vertex buffer. 
	//But Dx9 is incompatiable to translate this Dword into float4 with Dx10. Dx9 treats Dword as ARGB. Dx10 treats Dword as ABGR.
	//And Dword is padding with order ARGB in application layer. So a translation is needed in Dx10.
	float4 Diffuse = Input.Col.zyxw;
	float4 Specular = float4(0,0,0,0);
	float Glossness = 0;
	float Opacity = Input.Col.a;
	TripleColor Color = CalcLighting(Input.Pos, Viewer, ViewNormal, Emissive, Ambient, Diffuse, Specular, Glossness, Opacity
#ifdef SHADOWS
        , Out.ShadowD, Out.ShadowS
#endif
        );
	Out.ColorD = Color.Diffuse;
	Out.ColorS = Color.Specular; 
		
#ifdef SHADOWS
    Out.ShadowPos = mul(mul(LocalPos, g_matWorld), gShadowMapXf);
#endif

	if(g_fogEnabled)
	{
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
 	  //Apply user specified clipping
    	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
    	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
    	if( g_bClippingEnable )
    	{
		CalcClipping(LocalPos, Out);
    	}
	return Out;
}
//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_PosNormColTex( VSOutput Input ) : SV_Target
{
#ifdef SHADOWS
    float shadowFactor = SampleShadowMap(Input.ShadowPos);
    Input.ColorD += Input.ShadowD * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
    Input.ColorS += Input.ShadowS * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
#endif

#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif

#ifdef ENVIRONMENT_TEXTURE	
	CalcEnvironmentTexture(Input,g_Specular,g_Misc.z);
#endif
	
	if(Input.ColorD.a < g_Misc.w)
		discard;
		
	float4 Color = saturate(Input.ColorD + Input.ColorS);

if(g_fogEnabled)
	return Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;
else
	return Color;
}
//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 PosTex
{
    pass P0
    {   
	SetVertexShader(CompileShader(vs_4_0,VS_PosNormColTex()));
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_PosNormColTex()) );
    }
}